import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/route/route.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/my_images.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/controller/home/home_controller.dart';
import 'package:viserpay_agent/view/components/buttons/circle_animated_button_with_text.dart';
import 'package:viserpay_agent/view/screens/bottom_nav_section/home/components/main_items_bottom_sheet.dart';

class MainItemSection extends StatelessWidget {
  const MainItemSection({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<HomeController>(
        builder: (controller) => Container(
              width: MediaQuery.of(context).size.width,
              padding: const EdgeInsets.symmetric(vertical: Dimensions.space15, horizontal: Dimensions.space10),
              decoration: BoxDecoration(color: MyColor.getCardBgColor()),
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Expanded(
                    child: CircleAnimatedButtonWithText(
                      height: 56,
                      width: 56,
                      buttonName: MyStrings.cashIn,
                      backgroundColor: const Color(0xFF9D94FF).withOpacity(0.1),
                      child: Image.asset(MyImages.cashIn, color: const Color(0xFF9D94FF), height: 26, width: 26),
                      onTap: () {
                        Get.toNamed(RouteHelper.cashInScreen);
                      },
                    ),
                  ),
                  Expanded(
                    child: CircleAnimatedButtonWithText(
                      height: 56,
                      width: 56,
                      buttonName: MyStrings.transaction,
                      backgroundColor: const Color(0xFF59ADF6).withOpacity(0.1),
                      child: SvgPicture.asset(MyImages.transaction, colorFilter: const ColorFilter.mode(Color(0xFF59ADF6), BlendMode.srcIn), height: 26, width: 26),
                      onTap: () => Get.toNamed(RouteHelper.transactionHistoryScreen),
                    ),
                  ),
                  Expanded(
                    child: CircleAnimatedButtonWithText(
                      buttonName: MyStrings.commissionLog,
                      height: 56,
                      width: 56,
                      backgroundColor: const Color(0xFF08CAD1).withOpacity(0.1),
                      child: Image.asset(MyImages.commissionLog, color: const Color(0xFF08CAD1), height: 26, width: 26),
                      onTap: () {
                        Get.toNamed(RouteHelper.transactionHistoryScreen, arguments: MyStrings.commission);
                      },
                    ),
                  ),
                  Expanded(
                    child: controller.isAddMoneyModuleEnable || controller.isWithdrawModuleEnable
                        ? CircleAnimatedButtonWithText(
                            buttonName: MyStrings.seeMore,
                            height: 56,
                            width: 56,
                            backgroundColor: const Color(0xFFFF6961).withOpacity(0.1),
                            child: SvgPicture.asset(
                              MyImages.seeMore,
                              height: 26,
                              width: 26,
                              color: const Color(0xFFFF6961),
                            ),
                            onTap: () => MainItemBottomSheet.mainItemBottomSheet(context),
                          )
                        : const SizedBox(),
                  ),
                ],
              ),
            ));
  }
}
